C      *****************************************************************
C      * Subroutine StartUp                                            *
C      * When the soil model is called for the first time, this routine*
C      * initializes variables, checks that the proper components are  *
C      * present when the soil model is run with the tree model, checks*
C      * that the proper components are present for decomposition, and *
C      * constructs list of species with phase dependencies.           *
C      * If everything is successful, the variable GoAhead is returned *
C      * as a one, otherwise it is returned as a zero.  Also, if the   *
C      * proper components are not present for decomposition, decomp-  *
C      * osition is turned off.                                        *
C      *                                                               *
C      * Variables:                                                    *
C      * GoAhead   -In/Out- Indicates whether any errors were found.   *
C      *                    (GoAhead=1, no errors found; GoAhead=0,    *
C      *                    errors found.)  Unitless.                  *
C      * N_Index   -Output- The index number for the component whose   *
C      *                    known total is to be updated by the        *
C      *                    mineralized nitrogen.  Unitless.           *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * NitInor   -Output- A vector of size NLayers, of the amount of *
C      *                    inorganic soil nitrogen  per layer.  Units *
C      *                    are g N.                                   *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * NLayers   -Input - The number of soil layers in the system.   *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VPos, file VModel.f)         *
C      * OutInfo   -Output- Indicates whether or not detailed          *
C      *                    information is output.  Unitless.          *
C      *                    (Common block VModel, file VModel.f)       *              
C      * StndAlone -Input - Indicates whether soil model is running as *
C      *                    a stand alone model (TRUE) or not (FALSE). * 
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * UseDecomp -In/Out- Indicates whether decomposition is to be   *
C      *                    run (TRUE) or not (FALSE).  Unitless.      *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * YASOut    -Input - The output file number for the YASEQL      *
C      *                    model.  Unitless.                          *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE STARTUP(GOAHEAD)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER GOAHEAD, i

C      *-----------------------------------------------------------*
C      * Initialize variables that will remain constant.           *
C      * Read in soil chemistry description from a file (file name *
C      *    is passed by calling routine).                         *
C      *-----------------------------------------------------------*
       CALL INIT
							CALL INDAT(GOAHEAD)
							IF (GOAHEAD.NE.1) GOTO 9999

C      *---------------------------------------------------------*
C      * If the model is running with TREGRO then set the output *
C      * of detailed information to false no matter what it was  *
C      * read in as.                                             *
C      *---------------------------------------------------------*
       IF (NOT(STNDALONE)) OUTINFO = .FALSE.

C      *------------------------*
C      * Output the input data. *
C      *------------------------*
							CALL OUTDAT

C      *------------------------------------------------------*
C      * Process list of phases and construct list of species *
C      * with interdependencies.                              *
C      *------------------------------------------------------*
       CALL DEFINEPROB(GOAHEAD)
							IF (GOAHEAD.NE.1) GOTO 9999

C      *-----------------------------------------------------------*
C      * If the model is being called by TREGRO, set up the        *
C      * interface indices into the species concentration array.   *
C      * If a species required by TREGRO (species of interest) is  *
C      * not part of the system, output a message indicating this. *
C      *-----------------------------------------------------------*
							IF (.NOT.STNDALONE) THEN
	         CALL FINDINDEX
          CALL CHECKINDEX(GOAHEAD)
   							IF (GOAHEAD.NE.1) GOTO 9999
       ENDIF

C      *---------------------------------------------------------*
C      * Check that the appropriate information is available for *
C      * decomposition.  If it is not, turn off decomposition.   *
C      *---------------------------------------------------------*
       IF (USEDECOMP) CALL NITROCHECK(YASOUT, NLAYERS, USEDECOMP, 
     >  NITINOR, N_INDEX)

C      *--------------------*
C      * Error escape hatch *
C      *--------------------*
 9999  CONTINUE	 
  
       RETURN
	      END
C      *****************************************************************
C      *                   END SUBROUTINE                              *
C      *****************************************************************
